###############################################################################
#	Filename:	PhotonTorpedo.py
#	
#	Confidential and Proprietary, Copyright 2000 by Totally Games
#	
#	Script for filling in the attributes of photon torpedoes.
#	
#	Created:	11/3/00 -	Erik Novales
###############################################################################

import App

###############################################################################
#	Create(pTorp)
#	
#	Creates a photon torpedo.
#	
#	Args:	pTorp - the torpedo, ready to be filled-in
#	
#	Return:	zero
###############################################################################
def Create(pTorp):

	kCoreColor = App.TGColorA()
	kCoreColor.SetRGBA(204.0 / 255.0, 153.0 / 255.0, 76.0 / 255.0, 1.000000)
	kGlowColor = App.TGColorA()
	kGlowColor.SetRGBA(204.0 / 255.0, 102.0 / 255.0, 76.0 / 255.0, 1.000000)
	kFlareColor = App.TGColorA()
	kFlareColor.SetRGBA(230.0 / 255.0, 102.0 / 255.0, 76.0 / 255.0, 1.000000)

	# Params are:

	pTorp.CreateTorpedoModel(
					"data/Textures/Tactical/JLSSPhotonCore.tga",
					kCoreColor, 
					0.1,
					5.0,	 
					"data/Textures/Tactical/JLSSPhotonGlow.tga", 
					kGlowColor,
					1.0,	
					0.2,	 
					0.23,	
					"scripts/Textures/Tactical/JLSSQuantumBlank.tga",
					kFlareColor,										
					10,		
					0.07,		
					0.1)

	pTorp.SetDamage( GetDamage() )
	pTorp.SetDamageRadiusFactor(0.15)
	pTorp.SetGuidanceLifetime( GetGuidanceLifetime() )
	pTorp.SetMaxAngularAccel( GetMaxAngularAccel() )
	pTorp.SetLifetime( GetLifetime() )


	# Multiplayer specific stuff.  Please, if you create a new torp
	# type. modify the SpeciesToTorp.py file to add the new type.
	import Multiplayer.SpeciesToTorp
	pTorp.SetNetType (Multiplayer.SpeciesToTorp.PHOTON)

	return(0)

def GetLaunchSpeed():
	return(42.0)

def GetLaunchSound():
	return("JLSSovPhoton")

def GetPowerCost():
	return(20.0)

def GetName():
	return("Photon Torpedo")

def GetDamage():
	return 760.0

def GetGuidanceLifetime():
	return 20.0

def GetMaxAngularAccel():
	return 2.30
	
def GetLifetime():
	return 30.0

def GetFlashColor():
	return (200.0, 50.0, 20.0)
