###############################################################################
#	Filename:	WC_TNGquantum2.py
#	
#	Confidential and Proprietary, Copyright 2000 by Totally Games
#	
#	Script for filling in the attributes of WC_TNGquantum2 torpedoes.
#	
#	Created:	8/9/05 -	Sonic14 modified by WileyCoyote
###############################################################################

import App

###############################################################################
#	Create(pTorp)
#	
#	Creates a WC_TNGquantum2 torpedo.
#	
#	Args:	pTorp - the torpedo, ready to be filled-in
#	
#	Return:	zero
###############################################################################
def Create(pTorp):
	kCoreColor = App.TGColorA()
	kCoreColor.SetRGBA(255.0 / 255.0, 255.0 / 255.0, 255.0 / 255.0, 1.000000)
	kGlowColor = App.TGColorA()
	kGlowColor.SetRGBA(163.0 / 255.0, 206.0 / 255.0, 241.0 / 255.0, 1.000000)
	kFlareColor = App.TGColorA()
	kFlareColor.SetRGBA(33.0 / 255.0, 141.0 / 255.0, 250.0 / 255.0, 1.000000)	
	# Params are:

	pTorp.CreateTorpedoModel(
					"data/Textures/Tactical/TorpedoCore.tga",
					kCoreColor, 
					0.2,
					1.3,	 
					"data/Textures/Tactical/WC_quantumtorp.tga", 
					kGlowColor,
					1.0,	
					1.5,	 
					1.4,	
					"data/Textures/Tactical/WC_quantumtorpFlares.tga",
					kFlareColor,										
					5,		
					0.5,		
					0.2)

	pTorp.SetDamage( GetDamage() )
	pTorp.SetDamageRadiusFactor(0.15)
	pTorp.SetGuidanceLifetime( GetGuidanceLifetime() )
	pTorp.SetMaxAngularAccel( GetMaxAngularAccel() )

	# Multiplayer specific stuff.  Please, if you create a new torp
	# type. modify the SpeciesToTorp.py file to add the new type.
	import Multiplayer.SpeciesToTorp
	pTorp.SetNetType (Multiplayer.SpeciesToTorp.PHOTON)

	return(0)

def GetLaunchSpeed():
	return(30.0)

def GetLaunchSound():
	return("Quantum Torpedo")

def GetPowerCost():
	return(20.0)

def GetName():
	return("Quantum")

def GetDamage():
	return 1700.0

def GetGuidanceLifetime():
	return 30.0

def GetMaxAngularAccel():
	return 1.0
